// InjectDll.cpp
//

/*----------------------------------------------------------------------------------------------
  CInjectLib class

  : ܺ μ  ϴ DLL εϴ ƾ Ѵ. 
    ̶ μ ڽ DLL εϴ   ϸ,
	̸ ̿ؼ Լä ƾ   DLL ħ
	ų  ִ.

  designed by Sang-hoon. Sung
----------------------------------------------------------------------------------------------*/

#include "stdafx.h"
#include <windows.h>
#include <stddef.h>
#include <stdio.h>
#include "injectlib.h"

// Ʈ̽
void TraceDebug(LPCTSTR pszFmt, ...)
{
	char szBuf[256];
	
	va_list argList;
	va_start(argList, pszFmt);
		vsprintf(szBuf, pszFmt, argList);
		OutputDebugString(szBuf);
	va_end(argList);
}

#ifndef TRACE
#define TRACE	TraceDebug
#endif

void CInjectLib::DebugLoop()
{
	DEBUG_EVENT event;
	DWORD dwContinueStatus;

	while(1)
	{
		//  ̺Ʈ ߻Ҷ 
		WaitForDebugEvent(&event, INFINITE);

		dwContinueStatus = DBG_EXCEPTION_NOT_HANDLED;

		if(CREATE_PROCESS_DEBUG_EVENT == event.dwDebugEventCode)
		{
			//  μ  ̺Ʈ
			TRACE("CREATE_PROCESS_DEBUG_EVENT fired !!\n");

			//  μ 
			m_ProcessDebugInfo = event.u.CreateProcessInfo;

			// Ȱȭ μ Ÿ  (DebugActiveProcess(...))
			if(m_bActiveAttach)
			{
				TRACE("Attach Active Process !! - InjectSpyDll() Call !!\n");

				// 극ũ Ʈ óѴ.
				InjectSpyDll();

				// 극ũ Ʈ ī 
				m_uBreakCount++;
				dwContinueStatus = DBG_CONTINUE;
			}
		}
		else if(EXCEPTION_DEBUG_EVENT == event.dwDebugEventCode)
		{
			//   ̺Ʈ
			TRACE("EXCEPTION_DEBUG_EVENT fired !!\n");
			HandleException(&event, &dwContinueStatus);
		}
		else if(EXIT_PROCESS_DEBUG_EVENT == event.dwDebugEventCode)
		{
			//  μ  ̺Ʈ
			TRACE("EXIT_PROCESS_DEBUG_EVENT fired !!\n");
			return;
		}

		//  μ  ѱ.
		ContinueDebugEvent(event.dwProcessId, event.dwThreadId, dwContinueStatus);
	}
}

void CInjectLib::HandleException(LPDEBUG_EVENT pEvent, LPDWORD pContinueStatus)
{
	// 극ũ Ʈΰ?
	if(EXCEPTION_BREAKPOINT 
		== pEvent->u.Exception.ExceptionRecord.ExceptionCode)
	{
		TRACE("EXCEPTION_BREAKPOINT fired !!\n");

		if(0 == m_uBreakCount)
		{
			// ù° 극ũ Ʈ
			TRACE("First EXCEPTION_DEBUG_EVENT fired !! - InjectSpyDll() Call !!\n");
			if(!InjectSpyDll())
				TRACE("ERROR : InjectSpyDll() Fail !!\n");
		}
		else if(1 == m_uBreakCount)
		{
			// ι° 극ũ Ʈ
			TRACE("Second EXCEPTION_DEBUG_EVENT fired !! - ReplaceOriginalPagesAndContext() Call !!\n");
			if(!ReplaceOriginalPagesAndContext())
				TRACE("ERROR : ReplaceOriginalPagesAndContext() Fail !!\n");
		}

		m_uBreakCount++;
		*pContinueStatus = DBG_CONTINUE;
	}
	else
		*pContinueStatus = DBG_EXCEPTION_NOT_HANDLED;
}

BOOL CInjectLib::InjectSpyDll()
{
	// LoadLibraryA() ּ
	FARPROC pfnLoadLibrary = GetProcAddress(
		GetModuleHandle("KERNEL32.DLL"), "LoadLibraryA");
	
	//  μ ù°  
	m_pFirstCodePage = FindFirstCodePage(m_ProcessDebugInfo.hProcess, 
		m_ProcessDebugInfo.lpBaseOfImage);
	
	//   ؽƮ 
	m_OrgContext.ContextFlags = CONTEXT_CONTROL;
	GetThreadContext(m_ProcessDebugInfo.hThread, &m_OrgContext);
	
	BOOL	bRetCode;
	DWORD	cBytesMoved;

	//  μ ù°  
	bRetCode = ReadProcessMemory(m_ProcessDebugInfo.hProcess, m_pFirstCodePage, 
		m_pOrgCodePage, sizeof(m_pOrgCodePage), &cBytesMoved);
    if(!bRetCode || sizeof(m_pOrgCodePage) != cBytesMoved)
        return FALSE;
	
	//  DLL  ε ƾ  ü 
	PFAKE_LOADLIBRARY_CODE pNewCode = (PFAKE_LOADLIBRARY_CODE)m_pFakeCodePage;
	
	// sub esp, 1000h
    pNewCode->instr_SUB = 0xEC81;
    pNewCode->operand_SUB_value = PAGE_SIZE; // ũ(4096);
	
	// push <Ű>
	pNewCode->instr_PUSH = 0x68;
	pNewCode->operand_PUSH_value = (DWORD)m_pFirstCodePage 
		+ offsetof(FAKE_LOADLIBRARY_CODE, data_DllName);
	
	// call <Լּ> ; LoadLibraryA() ȣ
	pNewCode->instr_CALL = 0xE8;
	pNewCode->operand_CALL_offset = (DWORD)pfnLoadLibrary 
		- (DWORD)m_pFirstCodePage - offsetof(FAKE_LOADLIBRARY_CODE, instr_CALL) - 5;
	
	//  극ũ Ʈ 
	pNewCode->instr_INT_3 = 0xCC;
	
	// Ű (ε  DLL)
	char pszDll[MAX_PATH];
	if(!GetSpyDllName(pszDll, sizeof(pszDll)))
		return FALSE;
	strcpy(pNewCode->data_DllName, pszDll);
	
	// 츮 ƾ μ Write !!
	bRetCode = WriteProcessMemory(m_ProcessDebugInfo.hProcess, m_pFirstCodePage, 
		&m_pFakeCodePage, sizeof(m_pFakeCodePage), &cBytesMoved);
    if(!bRetCode || sizeof(m_pFakeCodePage) != cBytesMoved)
        return FALSE;
	
	//  (EIP) ù°  
	m_FakeContext = m_OrgContext;
	m_FakeContext.Eip = (DWORD)m_pFirstCodePage;
	
	//   ؽƮ 
	if(!SetThreadContext(m_ProcessDebugInfo.hThread, &m_FakeContext))
		return FALSE;

	return TRUE;
}

BOOL CInjectLib::ReplaceOriginalPagesAndContext()
{
	BOOL	bRetCode;
	DWORD	cBytesMoved;

	// ù°   ؽƮ  ǵ.
	bRetCode = WriteProcessMemory(m_ProcessDebugInfo.hProcess, m_pFirstCodePage, 
		m_pOrgCodePage, sizeof(m_pOrgCodePage), &cBytesMoved);
    if(!bRetCode || sizeof(m_pOrgCodePage) != cBytesMoved)
        return FALSE;

	if(!SetThreadContext(m_ProcessDebugInfo.hThread, &m_OrgContext))
		return FALSE;

	return TRUE;
}

LPVOID CInjectLib::FindFirstCodePage(HANDLE hProcess, LPVOID pProcessBase)
{
	BOOL	bRetCode;
	DWORD	cBytesMoved;
	DWORD	peHdrOffset, baseOfCode;

	//  μ ù°  .
	bRetCode = ReadProcessMemory(hProcess, (PBYTE)pProcessBase + offsetof(IMAGE_DOS_HEADER, e_lfanew),
		&peHdrOffset, sizeof(peHdrOffset), &cBytesMoved);
    if(!bRetCode || sizeof(peHdrOffset) != cBytesMoved)
        return FALSE;

	bRetCode = ReadProcessMemory(hProcess, (PBYTE)pProcessBase + peHdrOffset
		+ 4 + IMAGE_SIZEOF_FILE_HEADER
		+ offsetof(IMAGE_OPTIONAL_HEADER, BaseOfCode),
		&baseOfCode, sizeof(baseOfCode), &cBytesMoved);
    if(!bRetCode || sizeof(baseOfCode) != cBytesMoved)
        return FALSE;

	return (LPVOID)((DWORD)pProcessBase + baseOfCode);
}

BOOL CInjectLib::GetSpyDllName(LPSTR pBuf, UINT cBytes)
{
    char szBuffer[MAX_PATH];
    LPSTR pszFilename;
    
    //  DLL   ()   ؾ Ѵ.
    GetModuleFileName(NULL, szBuffer, sizeof(szBuffer));

    pszFilename = strrchr(szBuffer, '\\');
    if(!pszFilename)
        return FALSE;
    
    strcpy(pszFilename+1, m_szSpyDll);
    strncpy(pBuf, szBuffer, cBytes);

    return TRUE;
}

CInjectLib::CInjectLib()
{
	m_uBreakCount = 0;
	memset(m_szSpyDll, 0, MAX_PATH);
	m_bActiveAttach = FALSE;
}

BOOL CInjectLib::InjectSpyDll(LPCTSTR szCmdLine, LPCTSTR szDll)
{
	m_uBreakCount = 0;
	strcpy(m_szSpyDll, szDll);

	PROCESS_INFORMATION ProcessInfo;
	memset(&ProcessInfo, 0, sizeof(ProcessInfo));

	STARTUPINFO StartupInfo;
	memset(&StartupInfo, 0, sizeof(StartupInfo));
	StartupInfo.cb = sizeof(StartupInfo);

	if(CreateProcess(NULL, 
		(LPSTR)szCmdLine, 
		0, 
		0, 
		FALSE,
		DEBUG_ONLY_THIS_PROCESS, 
		0, 
		0, 
		&StartupInfo, 
		&ProcessInfo))
	{
		m_bActiveAttach = FALSE;

		DebugLoop();

		return TRUE;
	}

	return FALSE;
}

BOOL CInjectLib::InjectSpyDll(DWORD dwProcessId, LPCTSTR szDll)
{
	//  ʾ !!

	return FALSE;
}