// HookDll.cpp : Defines the entry point for the DLL application.
//

#include "stdafx.h"

//---------------------------------------------------
// Global Variables
//  ޸
//---------------------------------------------------
#pragma data_seg(".HKT")
HINSTANCE g_Module = NULL ;	// DLL Handle 
HHOOK g_Hook = NULL ;	// Hook Handle
HWND g_HwndServer = NULL ;	// Hook Server Window Handle
#pragma data_seg()

BOOL	RemoveHook() ;
BOOL	SetHook( HWND hWnd ) ;

typedef struct
{
	int		Type ;
	WPARAM	Data ;
	LPARAM	lParam ;
} HEVENT;


//------------------------------------------------------------------
// DllMain : Entry point
//------------------------------------------------------------------
BOOL APIENTRY DllMain( 
						HANDLE hModule, 
						DWORD  ul_reason_for_call, 
						LPVOID lpReserved
					)
{
	switch (ul_reason_for_call)
	{
	case DLL_PROCESS_ATTACH:
		g_Module = (HINSTANCE)hModule; // Save Dll Handle
		break;
		
	case DLL_PROCESS_DETACH:
		RemoveHook();
		break;
    }
	
    return TRUE;
}

//--------------------------------------------------------------
// Hook Procedure - Keyboard
//--------------------------------------------------------------
LRESULT CALLBACK KeyboardProcedure(int nCode, WPARAM wParam, LPARAM lParam)
{
	if( nCode >= 0 )
	{
		// Send To HookServer
		COPYDATASTRUCT  CDS;
		HEVENT          Event;
		// Set CDS
		CDS.dwData = 0 ;
		CDS.cbData = sizeof(Event);
		CDS.lpData = &Event;
		// Set Variables
		Event.Type = 1 ;		// It's WM_KEY.. 
		Event.Data = wParam ;	// Send CharCode
		Event.lParam = lParam ;
		
		::SendMessage( g_HwndServer , WM_COPYDATA , 0 , (LPARAM)(VOID*)&CDS ) ;	
		
	}
	// We must pass the all messages on to CallNextHookEx.
	return ::CallNextHookEx( g_Hook , nCode , wParam , lParam );
}

//------------------------------------------------------------------
// Set Hook
//------------------------------------------------------------------
BOOL	SetHook( HWND hWnd ) 
{
	g_HwndServer = hWnd ;		// Set Hook Server
	g_Hook = SetWindowsHookEx( WH_KEYBOARD , KeyboardProcedure , (HINSTANCE)g_Module , 0 ) ;
	
	return false ;
}

//------------------------------------------------------------------
// Remove Hook
//------------------------------------------------------------------
BOOL	RemoveHook() 
{
	UnhookWindowsHookEx( g_Hook ) ;
	return true ;
}
