/*************************************************************************
/*
/*      Copyright 2004/02/03
/*      Author : Meng-Jer Tsai(Taiwan R.O.C)
/*      Email : mjtsai87@ms31.hinet.net
/*      Declaration and Agreement Statements:
/*      [1]This Program is free for redistribution with
/*         or without any modify of the source code containing
/*         in this source file on conditions that the Declaration
/*         and Agreement Statements is included.
/*      [2]If any damanage done to your computer system due to the 
/*         execution of the source code in this file, no responsibility
/*         will be taken by the Author.
/*      [3]Any commercial binary executable product developed based on 
/*         this source code must have the Copyright and all items in 
/*         this Declaration and Agreement Statements in its User License
/*         Agreement, or will be regarded as inappropriate occupy of 
/*         software creativity.
/*
/*************************************************************************/

/*************************************************************************
/*
/*      This is header file defined for all common reference to Device
/*      Extension Structure and CompleteRequest API, which is responsible
/*      for IRP completion.
/*************************************************************************/

#ifndef WDMDEFAULT_H
#define WDMDEFAULT_H

/*
Device Extension Structure defined by WDM writer
*/
typedef struct tagDEVICE_EXTENSION {
	PDEVICE_OBJECT DeviceObject;		// device object this driver creates
	PDEVICE_OBJECT NextDeviceObject;	// next-layered device object in this device stack
	DEVICE_CAPABILITIES pdc;		// device capability
	IO_REMOVE_LOCK RemoveLock;		// removal control locking structure
	LONG handles;				// # open handles
	PVOID DataBuffer;                       // Internal Buffer for Read/Write I/O
	UNICODE_STRING Device_Description;	// Device Description
        SYSTEM_POWER_STATE SysPwrState;		// Current System Power State
        DEVICE_POWER_STATE DevPwrState;		// Current Device Power State
	PIRP PowerIrp;				// Current Handling Power-Related IRP
} DEVICE_EXTENSION, *PDEVICE_EXTENSION;

/*
Device Power State Structure for Device Capability Handling
*/
typedef struct tagDEVICE_POWER_INFORMATION {
  BOOLEAN   SupportQueryCapability;
  ULONG  DeviceD1;
  ULONG  DeviceD2;
  ULONG  WakeFromD0;
  ULONG  WakeFromD1;
  ULONG  WakeFromD2;
  ULONG  WakeFromD3;
  SYSTEM_POWER_STATE  SystemWake;
  DEVICE_POWER_STATE  DeviceWake;
  DEVICE_POWER_STATE  DeviceState[PowerSystemMaximum];
} DEVICE_POWER_INFORMATION, *PDEVICE_POWER_INFORMATION;

/*
Self-Defined I/O Control Code
*/
//I/O Control Code for Device Information retrieval
#define IOCTL_READ_DEVICE_INFO              \
        CTL_CODE(                           \
                    FILE_DEVICE_UNKNOWN,    \
                    0x800,                  \
                    METHOD_BUFFERED,        \
                    FILE_ANY_ACCESS)
                    
//I/O Control Code for Power Information retrieval
#define IOCTL_READ_POWER_INFO	          \
	CTL_CODE(			  \
		 FILE_DEVICE_UNKNOWN,	  \
		 0x801,			  \
		 METHOD_BUFFERED,	  \
		 FILE_ANY_ACCESS)

NTSTATUS
  CompleteRequest(
		IN PIRP Irp,
		IN NTSTATUS status,
		IN ULONG_PTR info);
#endif
