/////////////////////////////////////////////////////////////////////////
//
//	JAEHOON'S K HASHING ALGORITHM - VERSION 1. (JKHA-1)
//      COPYLEFT (C) 2012 Jaehoon, All rights shared.
//
//	LICENSE : LGPL v2.0
//	E-MAIL : rotodi1234@naver.com
//	PHONE : +82.010-8857-2327
//	PROJECT PAGE : http://dev.naver.com/projects/jcl2012 (KOREAN)
//
/////////////////////////////////////////////////////////////////////////

#include <stdio.h>
#include <stdlib.h>
#include <malloc.h>
#include <math.h>
#include <string.h>
#include "khash.h"

///////////////////////////////////////////////////////////////////////////////////////////////////////////////
// DON'T CHANGE TEXT FOR KEEPING COMPATIBILITY!                                                              //
// IF YOU WANT TO CHANGE, YOU REMEMBER "NO COMPATIBILITY WITH OTHERS".                                       //
// THE STANDARD HASH HELPERS ARE COMMITING TO INCREASE SOFTWARE COMPATIBILITY.                               //
///////////////////////////////////////////////////////////////////////////////////////////////////////////////
LPCHAR stringEncodian = "aA0bB1cC2dD3eE4fF5gG6hH7iI8jJ9kK0lL1mM2nN3oO4pP5qQ6rR7sS8tT9uU0vV1wW2xX3yY4zZ5\0\0";//
LPCHAR hashHelper = "Hajf471FrB7pjB5AXcW61YThb224Nx5fW0Kqj0Bb2Wg17c9N2KuAd2LzpZISTV7p168IUtNL3F3PCSOd54AbI1";//
LPCHAR hashHelper2 = "0zS9T4824c2i200PC1NX7hdk7ZC3mi5x1C20k4QO4MuolIXKOrlNSp36hlz04IGl9F4dt25G4O2dwI2N0zvll";//
///////////////////////////////////////////////////////////////////////////////////////////////////////////////

/////////////////////////////////////////////////
//
// WORD khashTransform(BYTE byte);
// - excuting transform one byte to two bytes.
//
// DESCRIPTION:
//
//     f(X) = hashHelper[X]
//     g(X) = hashHelper2[X]
//     len(X) = strlen(X)
//
//     a = (b^3 + f(b % len(f)) * g((b >> 3) % len(g)) * b) / (len(f) * len(g))
//     (sin(a) > 0 or sin(a) < 0) a = a * b
//     a = a >> 16
//
//     return a;
//
/////////////////////////////////////////////////

WORD khashTransform(BYTE byte){
	WORD base = (WORD)(((byte * byte * byte+
		 hashHelper[byte % (strlen(hashHelper))] *
		 hashHelper2[((byte) >> 3) % (strlen(hashHelper2))] ) * byte
		) / strlen(hashHelper) / strlen(hashHelper2) );

	DWORD rr = base * base;
	double ss = sin(base);

	rr = rr * byte;
	if(ss != 0.0) rr = rr * ss;
	rr = rr >> 16;

	return (WORD)rr;
}

///////////////////////////////////////////////////////////
//                                                         
// khashHash(LPCHAR result, LPBYTE data, DWORD dataLength) 
// - result : result string. this size must be same or     
//	over exactly with KHASH_OUTPUT_LENGTH macro.       
// - data : data for hashing.                              
// - dataLength : size of data.                            
//                                                         
/////////////////////////////////////////////////////////////

VOID khashHash(LPCHAR result, LPBYTE data, DWORD dataLength){
	LPBYTE crackedWord = 0;
	BYTE hashChars[KHASH_OUTPUT_LENGTH] = {1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,0,};
	WORD wordBefore = 0;
	DWORD pos = 0; BYTE lpPos = 0;
	DWORD encodianCount = strlen(stringEncodian);
	CHAR charCurrent = 0; DWORD pos2 = 0;

	for(pos = 0; pos<KHASH_OUTPUT_LENGTH; pos++)
		hashChars[pos] = (pos + 1);

	for(pos = 0; pos<KHASH_OUTPUT_LENGTH; pos++)
		hashChars[hashChars[pos] % KHASH_OUTPUT_LENGTH] = hashChars[pos];

	crackedWord = (LPBYTE)&wordBefore;
	for(pos = 0; pos < dataLength; pos ++){
		if(lpPos >= KHASH_OUTPUT_LENGTH) lpPos = 0;

		wordBefore = khashTransform(*(data + pos));
		hashChars[lpPos] = (hashChars[lpPos] + 
			crackedWord[0] + crackedWord[1]) % 256;

		if(lpPos == KHASH_OUTPUT_LENGTH - 1){
			hashChars[0] = (hashChars[lpPos] + crackedWord[1]) % 256;
		}else{
                        hashChars[lpPos + 1] = (hashChars[lpPos] +
                                crackedWord[0]) % 256;
		}

		lpPos++;
	}

	for(pos = 0; pos < KHASH_OUTPUT_LENGTH; pos++){
		hashChars[pos] = (hashChars[pos] * hashChars[KHASH_OUTPUT_LENGTH - 1 - pos]) % 256;
	}


	for(pos2 = 0; pos2 < 3; pos2++){
		for(pos = 0; pos < KHASH_OUTPUT_LENGTH; pos++){
			hashChars[hashChars[pos] % KHASH_OUTPUT_LENGTH] = hashChars[pos];
			hashChars[pos] = ((hashChars[pos]) + hashChars[(hashChars[pos]) % KHASH_OUTPUT_LENGTH] / 2);
			hashChars[pos] = (hashChars[pos] * hashChars[pos]) % 256;
		}
	}

	for(pos2 = 0; pos2 < 3; pos2++){
		for(pos = 0; pos < KHASH_OUTPUT_LENGTH; pos++){
			hashChars[pos] = (hashChars[pos] + KHASH_OUTPUT_LENGTH) % 256;
			hashChars[hashChars[pos] % KHASH_OUTPUT_LENGTH] = hashChars[pos] 
						* sin(hashChars[hashChars[pos] % KHASH_OUTPUT_LENGTH]);
		}

		for(pos = 0; pos < KHASH_OUTPUT_LENGTH; pos++){
                        hashChars[pos] = (hashChars[pos] + KHASH_OUTPUT_LENGTH) % 256;
                        hashChars[hashChars[pos] % KHASH_OUTPUT_LENGTH] = hashChars[pos]
                                                * cos(hashChars[hashChars[pos] % KHASH_OUTPUT_LENGTH]);
                }
	}

	for(pos = 0; pos < KHASH_OUTPUT_LENGTH; pos++){
		charCurrent = *(stringEncodian + (hashChars[pos] % encodianCount));
		*(result + pos) = charCurrent;
	}
}

