/////////////////////////////////////////////////////////////////////////
//
//	JAEHOON'S K HASHING ALGORITHM - VERSION 1. (JKHA-1)
//      COPYLEFT (C) 2012 Jaehoon, All rights shared.
//
//	LICENSE : LGPL v2.0
//	E-MAIL : rotodi1234@naver.com
//	PHONE : +82.010-8857-2327
//	PROJECT PAGE : http://dev.naver.com/projects/jcl2012 (KOREAN)
//
/////////////////////////////////////////////////////////////////////////

#include <stdio.h>
#include <malloc.h>
#include <string.h>
#include "khash.h"
   
//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

int _non_arg_main(LPCHAR hashTarget){
	CHAR hashString[KHASH_OUTPUT_LENGTH + 1] = {0, };

	printf("kHash: hashing string \"%s\"\n", hashTarget);
	khashHash(hashString, (LPBYTE)hashTarget, strlen(hashTarget));

	printf("hashed: %s\n", hashString);
}

int _file_hash_main(LPCHAR fileName){
	DWORD nowProgress = 0;
	FILE *fp = 0;
	BYTE buffer[1024];
        CHAR hashString[KHASH_OUTPUT_LENGTH + 1] = {0, };
	LPBYTE fileBuffer = 0;
	DWORD fileSz = 0;
	DWORD readed = 0;

	printf("openning file and calculating size... ");
	fp = fopen(fileName, "rb+");
	fseek(fp, 0, SEEK_END);
	fileSz = ftell(fp);
	printf("SUCCESS\n");

	fileBuffer = (LPBYTE)malloc(fileSz);
	printf("memory allocated. loading data (size: %d)... ", fileSz);
	fseek(fp, 0, SEEK_SET);

	while(1){
		memset(buffer, 0, 1024);
		readed = fread(buffer, 1, 1024, fp);
		if(readed == 1024){
			memcpy(fileBuffer + nowProgress, buffer, 1024);
			nowProgress += 1024;
		}else if(readed >= 0){
			memcpy(fileBuffer + nowProgress, buffer, readed);
			nowProgress += readed;
			break;
		}else if(readed <= 0) break;
	}

	if(fileSz == nowProgress){
		printf("SUCCESS\n");
	}else printf("WARNNING! - ORIGINAL SZ : %d, LOADED SZ : %d\n", fileSz, nowProgress);
	fclose(fp);

        khashHash(hashString, (LPBYTE)fileBuffer, nowProgress);
	free(fileBuffer);
        
        printf("hashed: %s\n", hashString);
}

int main(int argc, LPCHAR* argv){
        printf("Jaehoon's K Hash Algorithm. JKHA-1\n");
        printf("Copyleft(C) 2012 Jaehoon, All rights shared.\n\n");

	argc--;
	if(argc == 0)
		_non_arg_main("hello everyone~!");
	else if(argc == 1)
		_non_arg_main(*(argv + 1));
	else if(argc == 2){
		if(strcmp(*(argv + 1), "-f") == 0){
			_file_hash_main(*(argv + 2));
		}else if(strcmp(*(argv + 1), "-h") == 0)
			_non_arg_main(*(argv + 2));
		else{
			printf("USAGE: jkha");
			printf("       jkha \"NORMAL STRING\"\n");
			printf("       jkha -f FILE_NAME\n");
		}
	}
}
